definition module commondef


//	Version 1.0.1

//	Common types for the event I/O system and their access rules:


import	StdClass
import	StdIOCommon
from	StdFunc		import St
// PA: Rect type is defined in the ostypes module.
from	ostypes		import Rect
import	osrgn		// PA: required for IntersectRgnRect
// RWS ---from	mac_types	import Rect, Ptr, WindowPtr, RgnHandle, Toolbox

/* RWS ---
/*	Modifier and keyboard rules:
*/
KeyMapToModifiers		:: !(!Int,!Int,!Int,!Int)	-> Modifiers
KeyEventInfo			:: !Int !Int !Int			-> (Bool,Bool,Bool)
IntToModifiers			:: !Int						-> Modifiers
ModifiersToInt			:: !Modifiers				-> Int
getASCII				:: !Int						-> Char		// ASCII code from message field of (KeyDown/AutoKey/KeyUp) Event
getMacCode				:: !Int						-> Int		// Key   code from message field of (KeyDown/AutoKey/KeyUp) Event
keyEventToKeyState		:: !Int						-> KeyState	// KeyState   from what    field of (KeyDown/AutoKey/KeyUp) Event


/*	Control structure rules:
*/
InGrafport				:: !WindowPtr !(St Toolbox .x)	!Toolbox -> (!.x,	!Toolbox)
InGrafport2				:: !WindowPtr !(IdFun Toolbox)	!Toolbox -> Toolbox
LocalToGlobal			:: !Point						!Toolbox -> (!Point,!Toolbox)
GlobalToLocal			:: !Point						!Toolbox -> (!Point,!Toolbox)
GetMousePosition		::								!Toolbox -> (!Point,!Toolbox)
WaitForMouseUp			::								!Toolbox -> Toolbox
--- RWS */

K`						:: .x !.y -> .y

/*	Calculation rules on Integers:
*/
Dist					::		!Int !Int -> Int
SetBetween				:: !Int !Int !Int -> Int
IsBetween				:: !Int !Int !Int -> Bool
minmax					::      !Int !Int -> (!Int,!Int)			// minmax a b = (min a b,max a b)


/*	Calculation rules on Points, Sizes, and Vectors:
*/
addPointVector			:: !Vector !Point		-> Point			// {vx,vy}+{x,y}={x=x+vx,y=y+vy}
addPointSize			:: !Size   !Point		-> Point			// {w, h }+{x,y}={x=x+w, y=y+h }

/* RWS ---
/*	Rules on Rects and Rectangles:
*/
LoadRect				:: !Ptr !Toolbox		-> (!Rect,!Toolbox)	// read  the Rect from memory
StoreRect				:: !Ptr !Rect !Toolbox	-> Toolbox			// write the Rect to   memory

PA: the following functions on Rect and Rectangle are exported because they are used for window/control handling. */

RectangleToRect			:: !Rectangle			-> Rect				// (l,t, r,b) such that l<=r && t<=b
RectToRectangle			:: !Rect				-> Rectangle		// (l,t, r,b) -> {{x=l,y=t},{x=r,y=b}}
ZeroRect				:: Rect
IsEmptyRect				:: !Rect				-> Bool				// (l,t, r,b) -> l==r || t==b
IsEmptyRectangle		:: !Rectangle			-> Bool				// {corner1,corner2} -> corner1.x==corner2.x || corner1.y==corner2.y
PointInRect				:: !Point  !Rect		-> Bool				// {x,y} (l,t, r,b) -> l<=x<=r && t<=y<=b
PointInRectangle		:: !Point  !Rectangle	-> Bool				// PointInRect point (RectangleToRect rectangle)
PosSizeToRect			:: !Point  !Size		-> Rect				// {x,y} {w,h} -> ( x,y,  x+w,y+h )	// no check on negative size
PosSizeToRectangle		:: !Point  !Size		-> Rectangle		// {x,y} {w,h} -> {{x,y},{x+w,y+h}}	// no check on negative size
SizeToRect				::		   !Size		-> Rect				//       {w,h} -> ( 0,0,    w,  h )	// no check on negative size
SizeToRectangle			::		   !Size		-> Rectangle		//       {w,h} -> {zero, {  w,  h}}	// no check on negative size
DisjointRects			:: !Rect   !Rect		-> Bool
IntersectRects			:: !Rect   !Rect		-> Rect				// if disjoint: EmptyRect; otherwise the intersection
AddRectVector			:: !Vector !Rect		-> Rect				// {vx,vy} (l,t, r,b)  -> (l+vx,t+vy, r+vx,b+vy)
AddRectangleVector		:: !Vector !Rectangle	-> Rectangle		// v {corner1,corner2} -> {corner1+v,corner2+v}
RectSize				:: !Rect				-> Size				// (l,t, r,b)          -> {abs (r-l), abs (b-t)}

/*	Rules on RgnHandles and Rects:
*/
IntersectRgnRect		:: !OSRgnHandle !Rect !*OSToolbox -> (!OSRgnHandle,!*OSToolbox)	// the intersection of the two arguments
/*	PA: DisjointRgnRect made invisible
DisjointRgnRect			:: !RgnHandle !Rect !Toolbox -> (!Bool,		!Toolbox)	// the intersection is empty
*/

/*	Conversion of Rectangle to UpdateState:
*/
RectangleToUpdateState	:: !Rectangle -> UpdateState				// r -> {oldFrame=newFrame=r,updArea=[r]}

/*	PA: three new functions that are used frequently:
	Conversion of Size, Point, and Vector to tuples:
*/
SizeToTuple  :: !Size  -> (!Int,!Int)
PointToTuple :: !Point -> (!Int,!Int)
VectorToTuple:: !Vector-> (!Int,!Int)


/*	Common Error generation rule:
*/
Error					:: !String !String !String -> .x
FatalError				:: !String !String !String -> .x


/*	Universal dummy value (!!evaluation causes termination with the message: "Fatal error: dummy evaluated!"!!)
*/
dummy					:: String -> .x


/*	Max Integer constants:
*/
MaxSigned2ByteInt		:== 32767		// 2^15-1
MaxSigned4ByteInt		:== 2147483647	// 2^31-1


/*	Bound data type:
*/
::	Bound
	=	Finite Int												// Fix a finite positive bound of N
	|	Infinite												// No bound

instance == Bound												// Finite i == Finite j && max 0 i == max 0 j; Infinite == Infinite
zeroBound:: !Bound -> Bool										// Finite i && i<=0
decBound :: !Bound -> Bound										// Finite i -> Finite (max 0 (i-1)); Infinite -> Infinite


/*	PA: code changed and moved to oswindow.
/*	Standard Scroll Bar settings:
*/
StdSliderMin			:== 0			// 0
StdSliderMax			:== 32767		// MaxSigned2ByteInt
StdSliderRange			:== 32767		// StdSliderMax-StdSliderMin

fromSliderRange			:: !Int !Int !Int -> Int
//	if (IsBetween x StdSliderMin StdSliderMax) then (IsBetween (fromSliderRange a b x) a b)
toSliderRange			:: !Int !Int !Int -> Int
//	if (IsBetween x a b) then (IsBetween (toSliderRange a b x) StdSliderMin StdSliderMax)
*/

/*	List operations:
*/
::	Cond  x :== x -> Bool
::	UCond x :== x -> (Bool,x)

IsSingleton				:: ![.x] -> Bool
HdTl					:: ![.x] -> (.x, [.x])
InitLast				:: ![.x] -> ([.x],.x)
Split					:: !Int ![.x] -> (![.x],![.x])

CondMap					:: (Cond x) !(IdFun x)		![x]		-> (!Bool, ![x])
Uspan					:: !(UCond .x)				![.x]		-> (![.x],![.x])	// Same as span (StdList), but preserving uniqueness
FilterMap				:: !(.x -> (Bool,.y))		![.x]		-> [.y]
StateMap				:: !(.x -> .s -> (.y,.s))	![.x] !.s	-> (![.y], !.s)
StateMap2				::  (.x -> .s -> .s)		![.x] !.s	-> .s
StrictSeq				:: ![.(.s -> .s)]				  !.s	-> .s				// Same as seq (StdFunc), but with strict state argument
StrictSeqList			:: !.[.St .s .x]				  !.s	-> (![.x],!.s)		// Same as seqList (StdFunc), but with strict state argument

Contains				:: (Cond    x)			![ x] -> Bool
UContains				:: (UCond  .x)			![.x] -> (!Bool,	![.x])
Select					:: (Cond    x)		  x	![ x] -> (!Bool, x)
Access					:: (St .x (Bool,.y)) .y	![.x] -> (!Bool,.y,	![.x])
AccessList				:: (St .x .y)			![.x] -> (![.y],	![.x])
Remove					:: (Cond    x)		  x ![ x] -> (!Bool, x,	![ x])
URemove					:: (UCond  .x)		 .x ![.x] -> (!Bool,.x,	![.x])
Replace					:: (Cond    x)		  x ![ x] -> (!Bool,	![ x])
UReplace				:: (UCond  .x)		 .x ![.x] -> (!Bool,	![.x])
RemoveCheck				::					 x !u:[x] -> (!Bool,  !u:[ x])	| Eq x
RemoveSpecialChars		:: ![Char] !{#Char}	-> {#Char}
Ulength					:: ![.x]			-> (!Int, ![.x])
disjointLists			:: ![x] ![x]		-> Bool		| Eq x
noDuplicates			:: ![x]				-> Bool		| Eq x
